function [f,df]  = linsystem_newton

f = @ode;
df = @jacobian;

end

function dxdt = ode(t, x)
% LINSYSTEM Implements the linear ODE:
%
%   x'=Ax
%
% where
%      [  998    1998 ]
%  A = [              ]
%      [ -999   -1999 ]

A = [998 1998; -999 -1999];
dxdt = A*x;
end

function dfdt = jacobian(t, x)
dfdt = [998 1998; -999 -1999];
end